// --- ms_subject.h -----------------------------------------------------------------------
// This file is used in the build of ms_model.dll, one of the two modules that form the
// application, Ms Resi.  It contains the complete specifications of the default subject.
// The core code of Ms Resi was developed from MacPuf. MacPuf is detailed in the text,
// "A Computer Model of Human Respiration", C. J.Dickinson, MTP Press, 1977.
// Further text on authorship is available at run time.
// Mal Haysom, Civil Engineering and Physical Sciences, La Trobe University, December 2009

// --- passport parameters ----------------------------------------------------------------
trade float s_height = 178.0;                                                         // cm
trade float s_weight = 70.0;                                                          // kg
trade float s_age    = 40.0;                                                        // year
trade int s_sex      = 1;                                           // 0 = female, 1 = male
// --- subject factors --------------------------------------------------------------------
trade float s_factor[] = {
                  3.8, // DPG     0  (23) 2,3-DPG concentration in red cells
                  0.0, // ADDC3   1  (21) Addition of bicarbonate or acid, standard bicarb.
                  0.0, // BAGCP   2       Bag CO2 percentage
                  0.0, // BAGOP   3       Bag O2 percentage
                10000, // BAGV    4 (116) Bag volume
                 37.0, // TEMP    5  (14) Body temperature
                  0.0, // BC3AJ   6  (22) Brain bicarbonate, deviation from normal (+/-)
                  100, // PR      7  (24) Breathing capacity
                  100, // CO      8   (3) Cardiac pump performance
                  100, // CZ      9  (12) Central neurogenic (learnt) respiratory drive
                    0, // FADM   10   (5) Extra anatomical right-to-left shunt
                  0.0, // BULLA  11   (6) Extra dead space (above normal value)
                 14.8, // HB     12  (18) Haemoglobin blood density
                 31.0, // FITNS  13  (25) Index of state of physical fitness
                 0.40, // SPACE  14  (26) Inspiratory/total breath duration ratio
                 0.03, // FIC2   15   (2) Inspired CO2 percentage
                20.93, // FIO2   16   (1) Inspired O2 percentage
                  0.0, // SHUNT  17  (28) Left-to-right shunt, ratio to cardiac output
                  5.0, // ELAST  18   (8) Lung elastance
                 3000, // VLUNG  19   (7) Lung volume, (end-expiration)
                 35.0, // COMAX  20  (27) Maximum cardiac output
                 45.0, // PCV    21  (19) Packed cell volume
                  0.0, // PEEP   22  (30) Positive end-expiratory pressure
                12.00, // TVOL   23  (17) Tissue ECF distribution volume
                  0.8, // TRQ    24  (15) Tissue respiratory quotient
                  760, // BARPR  25  (13) Total barometric pressure,
                  3.0, // VADM   26   (9) Venous admixture effect
                 3000, // VBLVL  27  (20) Venous blood volume
                  100, // AZ     28  (10) Ventilatory response to CO2 or H+
                  100, // BZ     29  (11) Ventilatory response to failing partial O2
                  5.0, // VC     30  (29) Vital capacity
                  0.0  // WRATE  31   (4) Work Rate
                    };

// --- physiological variables ------------------------------------------------------------
trade struct s_dsply s_display[] = {
    144.3, true,  0.00, // AC2MT  0  (40) Alveolar CO2 amount
    39.93, true,  0.00, // AC2PR  1  (42) Alveolar CO2 partial pressure
   1987.0, true,  0.00, // AN2MT  2  (65) Alveolar N2 amount
    347.0, true,  0.00, // AO2MT  3  (39) Alveolar O2 amount
    102.3, true,  0.00, // AO2PR  4  (41) Alveolar O2 partial pressure
     4.26, false, 0.00, // FVENT  5  (35) Alveolar ventilation
      0.0, true,  0.00, // BUBBL  6  (83) Arbitrary index of risk of decompression symptoms
    23.84, true,  0.00, // RC3CT  7  (60) Arterial CO2 amount
    474.0, true,  0.00, // RC2MT  8  (63) Arterial CO2 content
    47.35, true,  0.00, // RC2CT  9  (78) Arterial CO2 partial pressure
     39.9, true,  0.00, // RC2PR 10  (74) Arterial N2 partial pressure
     0.99, true,  0.00, // RLACT 11  (90) Arterial O2 amount
     7.22, true,  0.00, // RN2MT 12 (108) Arterial O2 content
    195.3, true,  0.00, // RO2MT 13  (62) Arterial O2 partial pressure
    19.54, true,  0.00, // RO2CT 14  (49) Arterial O2 saturation (maximum)
    93.18, true,  0.00, // RO2PR 15  (72) Arterial bicarbonate content
    97.13, true,  0.00, // PJ    16  (76) Arterial lactate concentration
      7.4, true,  0.00, // RPH   17  (33) Arterial pH
    47.35, true,  0.00, // EC2CT 18 (101) Arterial pool CO2 content of blood leaving
     0.72, true,  0.00, // EN2CT 19 (106) Arterial pool N2 content of blood leaving
    19.54, true,  0.00, // EO2CT 20  (94) Arterial pool O2 content of blood leaving
      0.0, true,  0.00, // BAGC  21  (38) Bag CO2 amount
      0.0, true,  0.00, // BAGO  22  (37) Bag O2 amount
    52.89, true,  0.00, // CBF   23  (68) Brain blood flow
    677.4, true,  0.00, // BC2MT 24  (67) Brain CO2 amount
    56.53, true,  0.00, // BC2CT 25  (58) Brain CO2 content of blood leaving
     52.8, true,  0.00, // BC2PR 26  (46) Brain CO2 partial pressure of blood leaving
    18.51, true,  0.00, // BO2MT 27  (66) Brain O2 amount
    10.21, true,  0.00, // BO2CT 28  (57) Brain O2 content of blood leaving
    29.87, true,  0.00, // BO2PR 29  (45) Brain O2 partial pressure of blood leaving
     22.7, true,  0.00, // BC3CT 30  (92) Brain bicarbonate content
     7.33, true,  0.00, // BPH   31  (36) Brain pH (at putative central chemoreceptor site)
     4.95, true,  0.00, // COADJ 32  (93) Cardiac output (actual effective)
    130.7, true,  0.00, // DSPAC 33  (70) Dead space (total effective physiological)
      0.0, true,  0.00, // UN2MT 34 (107) Excess N2 held above normal maximum saturation
     63.0, false, 0.00, // HRATE 35 (109) Heart rate
    100.0, false, 0.00, // PD    36  (81) Metabolic rate
    47.25, true,  0.00, // PC2CT 37  (53) Pulmonary capillary (idealized) blood CO2 content
    19.65, true,  0.00, // PO2CT 38  (54) Pulmonary capillary (idealized) blood O2 content
     0.80, false, 0.00, // RER   39  (69) Respiratory quotient
    12.82, false, 0.00, // RRATE 40  (48) Respiratory rate
    461.9, false, 0.00, // TIDVL 41  (47) Tidal volume
    25.52, true,  0.00, // TC3CT 42  (87) Tissue bicarbonate content of blood leaving
    51.51, true,  0.00, // TC2CT 43  (56) Tissue CO2 content of blood leaving
    45.43, true,  0.00, // TC2PR 44  (97) Tissue CO2 partial pressure
    13.39, true,  0.00, // TC2MT 45  (16) Tissue CO2 stores
    34.80, true,  0.00, // TLAMT 46  (89) Tissue lactate amount (body total)
    76.07, true,  0.00, // TN2MT 47 (102) Tissue N2 amount in fast compartment
    967.0, true,  0.00, // SN2MT 48 (112) Tissue N2 amount in slow compartment
    570.0, true,  0.00, // TN2PR 49 (103) Tissue N2 partial in fast compartment
    565.0, true,  0.00, // SN2PR 50 (105) Tissue N2 partial in slow compartment
    177.6, true,  0.00, // TO2MT 51  (95) Tissue O2 amount
    14.39, true,  0.00, // TO2CT 52  (55) Tissue O2 content of blood leaving
    40.00, true,  0.00, // TO2PR 53  (96) Tissue O2 partial (time shifted values)
     7.37, true,  0.00, // TPH   54  (59) Tissue pH
     6.06, false, 0.00, // DVENT 55  (51) Total ventilation
     2.36, true,  0.00, // PW    56  (80) Venous admixture (total effective)
    71.41, true,  0.00, // VC3MT 57  (86) Venous bicarbonate amount
    25.52, true,  0.00, // VC3CT 58  (88) Venous bicarbonate content (mixed venous)
   1540.0, true,  0.00, // VC2MT 59  (50) Venous CO2 amount
    51.33, true,  0.00, // VC2CT 60  (61) Venous CO2 content (blood in pulmonary artery)
    434.8, true,  0.00, // VO2MT 61  (98) Venous O2 amount
     14.5, true,  0.00, // VO2CT 62  (31) Venous O2 content of blood in pulmonary artery
     7.37, true,  0.00  // VPH   63  (34) Venous pH (of mixed venous blood)
                            };

// --- other subject parameters -----------------------------------------------------------
trade float s_other[] =    {
                  71.08, // AVENT  0  (99) alveolar ventilation (shorter iteration period)
                    1.0, // BO2AD  1  (92) index of brain oxygenation adequacy
                    4.6, // CONOM  2  (82) nominal resting cardiac output
                  240.0, // CONSO  3  (73) tissue O2 consumption, nominal resting value
                   7.40, // DPH    4  (43) arterial H+ activity (at end of each iteration)
                    4.0, // FEV    5 (104) forced expired volume
                    0.0, // PG     6  (75) index of time brain has been deprived of oxygen
                   33.6, // QA     7 (113) nett O2 uptake per iteration
                  33.29, // QB     8  (79) nett CO2 uptake per iteration
                   3000, // REFLV  9  (71) reference volume of lungs
                    0.0, // RVADM 10 (114) extra shunt effect for emphysematous subjects
                   6.06, // SVENT 11  (52) total effective ventilatory drive
                  45.72, // TC2RF 12  (84) reference value detecting CO2 partial pressure
                   0.10, // TC3AJ 13 (111) tissue bicarbonate adjusted
                  317.4, // TC3MT 14  (85) tissue bicarbonate amount
                    0.0, // XDSPA 15  (44) extra dead space for altered function tests
                    0.0, // XLACT 16 (115) local lactate concentration
                   8.88, // XRESP 17  (64) damping function respiratory drive
                 0.080,  // STRVL 18 (110) heart stroke volume GH
                  100.0  // RCOAJ 19  (32) arterial ... GH
                     };
#define NUM_OTH sizeof(s_other)/sizeof(float)                 // number of other parameters
//--- clinical codes ----------------------------------------------------------------------
#define set(F)	crrnt_state |= F                                // set clinical message bit
#define clr(F)	crrnt_state &= ~F                             // clear clinical message bit
#define tst(F)  (crrnt_state & F)                              // test clinical message bit

#define	S00     0X0001
#define	S01     0X0002
#define	S02     0X0004
#define	S03     0X0008
#define	S04     0X0010
#define	S05     0X0020
#define	S06     0X0040
#define	S07     0X0080
#define	S08     0X0100
#define	S09     0X0200
#define S10     0X0400
#define S11     0X0800
#define S12     0X1000
#define S13     0X2000

#define	ALL     -1                             // all clinical message bits, usage clr(ALL)

