//--- respiration.cpp ---------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include <stdlib.h>
#include <stdio.h>

#include "ms_variable.h"                                           
#include "respiration.h"

// ----------------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

// --- setup for imported variables -------------------------------------------------------
#define trade extern "C" __declspec(dllimport)

// --- utility functions ------------------------------------------------------------------
void set_button(int index);                     // sets bag radio button according to index
void set_bag_var(int b_index);          // enables or not variable entry according to index
float v_limit(float *v, float d);        // returns variable data constrained within limits

// --- imported variables -----------------------------------------------------------------
trade bool *ventilation;                                                // pointer to NARTI
trade float *res_rate;				                        // pointer to RRATE
trade float *tidal;                                                     // pointer to TIDVL
trade float *positive;                                                   // pointer to PEEP
trade int *bag_index;                               // pointer to index required by bager()
trade float *bag_vol;                                                    // pointer to BAGV
trade float *bag_co2;                                                    // pointer to BAGC
trade float *bag_o2;                                                     // pointer to BAGO

// --- externals from ms_resi_main.cpp ----------------------------------------------------
extern char wrk_bfa[];                                               // general work buffer

// --- holding variables ------------------------------------------------------------------
bool v_state;                                            // ventilation radio buttons state
int b_index;                                                     // bag radio buttons index

Trespiration_F *respiration_F;
// -----------------------------------------------------------------------------------------
__fastcall Trespiration_F::Trespiration_F(TComponent* Owner) : TForm(Owner)
{
}
// --- respiration_F form activate --------------------------------------------------------
void __fastcall Trespiration_F::FormActivate(TObject *Sender)
    {
    sprintf(wrk_bfa, "Respiration features not yet sensibly implemented.  " __DATE__);
    MessageDlg(wrk_bfa, mtWarning, TMsgDlgButtons() << mbOK, 0);
    sprintf(wrk_bfa, "%.2f", *res_rate);
    rrate_E->Text = wrk_bfa;
    sprintf(wrk_bfa, "%.2f", *tidal);
    tidal_E->Text = wrk_bfa;;
    v_state = *ventilation;
    respiration_F->natural_RB->Checked = v_state? true: false;
    respiration_F->artifical_RB->Checked = v_state? false: true;
    if(*ventilation)
        {
        rrate_E->Font->Color = clLtGray;
        tidal_E->Font->Color = clLtGray;
        peep_E->Font->Color = clLtGray;
        rrate_E->ReadOnly = true;
        tidal_E->ReadOnly = true;
        peep_E->ReadOnly = true;
        }
    else
        {
        rrate_E->Font->Color = clBlack;
        tidal_E->Font->Color = clBlack;
        peep_E->Font->Color = clBlack;
        rrate_E->ReadOnly = false;
        tidal_E->ReadOnly = false;
        peep_E->ReadOnly = false;
        }
    sprintf(wrk_bfa, "%.2f", *res_rate);
    rrate_E->Text = wrk_bfa;
    sprintf(wrk_bfa, "%.1f", *tidal);
    tidal_E->Text = wrk_bfa;
    sprintf(wrk_bfa, "%.1f", *positive);
    peep_E->Text = wrk_bfa;
    set_button(*bag_index);
    set_bag_var(*bag_index);
    sprintf(wrk_bfa, "%.1f", *bag_vol);
    bagv_E->Text = wrk_bfa;
    sprintf(wrk_bfa, "%.1f", *bag_co2);
    bagc_E->Text = wrk_bfa;
    sprintf(wrk_bfa, "%.1f", *bag_o2);
    bago_E->Text = wrk_bfa;
    }
// --- natural_RB click -------------------------------------------------------------------
void __fastcall Trespiration_F::natural_RBClick(TObject *Sender)
{
natural_RB->Checked = true;
artifical_RB->Checked = false;
rrate_E->Font->Color = clLtGray;
tidal_E->Font->Color = clLtGray;
peep_E->Font->Color = clLtGray;
rrate_E->ReadOnly = true;
tidal_E->ReadOnly = true;
peep_E->ReadOnly = true;
v_state = true;
}
// --- artifical_RB click -----------------------------------------------------------------
void __fastcall Trespiration_F::artifical_RBClick(TObject *Sender)
{
natural_RB->Checked = false;
artifical_RB->Checked = true;
rrate_E->Font->Color = clBlack;
tidal_E->Font->Color = clBlack;
peep_E->Font->Color = clBlack;
rrate_E->ReadOnly = false;
tidal_E->ReadOnly = false;
peep_E->ReadOnly = false;
v_state = false;
}
// --- ok_B click -------------------------------------------------------------------------
 // does checks, if okay loads stuff into variables and closes
void __fastcall Trespiration_F::ok_BClick(TObject *Sender)
    {
    float b_c, b_o;
    *ventilation = v_state;
    *res_rate = v_limit(res_rate, atof(rrate_E->Text.c_str()));
    *tidal  = v_limit(tidal, atof(tidal_E->Text.c_str()));
    *positive = v_limit(positive, atof(peep_E->Text.c_str()));
    *bag_index = b_index;                                    // acquire actual from holding
    *bag_vol = v_limit(bag_vol, atof(bagv_E->Text.c_str()));
    b_c = v_limit(bag_co2, atof(bagc_E->Text.c_str()));
    b_o = v_limit(bag_o2, atof(bago_E->Text.c_str()));
    if(b_c + b_o > 100)
        {
        Beep();
        ShowMessage("Sum of percentages exceeds 100%");
        return;
        }
    *bag_co2 = b_c;
    *bag_o2 = b_o;
    bager(RSP, NULL, NULL);					    // do bager() processes
    respiration_F->Close();
    }
// --- cancel_B click ---------------------------------------------------------------------
// closes without making changes
void __fastcall Trespiration_F::cancel_BClick(TObject *Sender)
    {
    respiration_F->Close();  					    
    }
// --- bag_RB click -----------------------------------------------------------------------
// services all the bag radio buttons.
void __fastcall Trespiration_F::bag_RBClick(TObject *Sender)
    {
    bag1_RB->Checked = (Sender == bag1_RB)? bool(b_index = GTC): false;
    bag2_RB->Checked = (Sender == bag2_RB)? bool(b_index = CXA): false;
    bag3_RB->Checked = (Sender == bag3_RB)? bool(b_index = RBB): false;
    bag4_RB->Checked = (Sender == bag4_RB)? bool(b_index = CDA): false;
    bag5_RB->Checked = (Sender == bag5_RB)? bool(b_index = STD): false;
    set_bag_var(b_index);
    }
// --- set_button() -----------------------------------------------------------------------
void set_button(int index)
    {
    respiration_F->bag1_RB->Checked = (index == GTC)? true: false;
    respiration_F->bag2_RB->Checked = (index == CXA)? true: false;
    respiration_F->bag3_RB->Checked = (index == RBB)? true: false;
    respiration_F->bag4_RB->Checked = (index == CDA)? true: false;
    respiration_F->bag5_RB->Checked = (index == STD)? true: false;
    }
// --- v_limit() --------------------------------------------------------------------------
// float v_limit() returns variable data constrained within appropriate limits.
float v_limit(float *variable, float data)
    {
    if(data < *(variable+1))         // lower limit is next float to value
        data = *(variable+1);
    if(data > *(variable+2))         // upper limit is 2 floats along from value
        data = *(variable+2);
    return(data);
    }
// --- set_bag_var() ----------------------------------------------------------------------
// void set_bag_var() enables or not variable entry according to bag index
void set_bag_var(int b_index)
    {
    switch(b_index)
        {
        case GTC:
        case STD:
                respiration_F->bagv_E->Font->Color = clLtGray;
                respiration_F->bagv_E->ReadOnly = true;
                respiration_F->bagc_E->Font->Color = clLtGray;
                respiration_F->bagc_E->ReadOnly = true;
                respiration_F->bago_E->Font->Color = clLtGray;
                respiration_F->bago_E->ReadOnly = true;
                break;
        case CXA:
        case RBB:
        case CDA:
                respiration_F->bagv_E->Font->Color = clBlack;
                respiration_F->bagv_E->ReadOnly = false;
                respiration_F->bagc_E->Font->Color = clBlack;
                respiration_F->bagc_E->ReadOnly = false;
                respiration_F->bago_E->Font->Color = clBlack;
                respiration_F->bago_E->ReadOnly = false;
                break;
        }
    }
// ----------------------------------------------------------------------------------------

