// --- ms_subject.h -----------------------------------------------------------------------
// This file is used in the build of ms_model.dll, one of the two modules that form the
// application, Ms Resi.  It contains the complete specifications of the default subject.
// The core code of Ms Resi was developed from MacPuf. MacPuf is detailed in the text,
// "A Computer Model of Human Respiration", C. J.Dickinson, MTP Press, 1977.
// Further text on authorship is available at run time.
// Mal Haysom, Civil Engineering and Physical Sciences, La Trobe University, December 2009

// --- passport parameters ----------------------------------------------------------------
trade float s_height = 178.0;                                                         // cm
trade float s_weight = 70.0;                                                          // kg
trade float s_age    = 40.0;                                                        // year
trade int s_sex      = 1;                                           // 0 = female, 1 = male
// --- subject factors --------------------------------------------------------------------
trade float s_factor[] = {
                        3.8, // DPG     0  (23)
                        0.0, // ADDC3   1  (21)
                        0.0, // BAGCP   2
                        0.0, // BAGOP   3
		      10000, // BAGV    4 (116)
		       37.0, // TEMP    5  (14)
                        0.0, // BC3AJ   6  (22)
                        100, // PR      7  (24)
                        100, // CO      8   (3)
                        100, // CZ      9  (12)
                          0, // FADM   10   (5)
                        0.0, // BULLA  11   (6)
                       14.8, // HB     12  (18)
                       31.0, // FITNS  13  (25)
                       0.40, // SPACE  14  (26)
                       0.03, // FIC2   15   (2)
                      20.93, // FIO2   16   (1)
                        0.0, // SHUNT  17  (28)
                        5.0, // ELAST  18   (8)
                       3000, // VLUNG  19   (7)
                       35.0, // COMAX  20  (27)
                       45.0, // PCV    21  (19)
                        0.0, // PEEP   22  (30)
                      13.39, // TC2MT  23  (16)
                      12.00, // TVOL   24  (17)
                        0.8, // TRQ    25  (15)
                        760, // BARPR  26  (13)
                        3.0, // VADM   27   (9)
                       3000, // VBLVL  28  (20)
                        100, // AZ     29  (10)
                        100, // BZ     30  (11)
                        5.0, // VC     31  (29)
                        0.0  // WRATE  32  (32)
                    };

// --- physiological variables ------------------------------------------------------------
trade struct s_dsply s_display[] = {
                              144.3, true,  0.00, // AC2MT  0  (40)
                              39.93, true,  0.00, // AC2PR  1  (42)
                             1987.0, true,  0.00, // AN2MT  2  (65)
                              347.0, true,  0.00, // AO2MT  3  (39)
                              102.3, true,  0.00, // AO2PR  4  (41)
                               4.26, false, 0.00, // FVENT  5  (35)
                                0.0, true,  0.00, // BUBBL  6  (83)
                              23.84, true,  0.00, // RC3CT  7  (60)
                              474.0, true,  0.00, // RC2MT  8  (63)
                              47.35, true,  0.00, // RC2CT  9  (78)
                               39.9, true,  0.00, // RC2PR 10  (74)
                               0.99, true,  0.00, // RLACT 11  (90)
                               7.22, true,  0.00, // RN2MT 12 (108)
                              195.3, true,  0.00, // RO2MT 13  (62)
                              19.54, true,  0.00, // RO2CT 14  (49)
                              93.18, true,  0.00, // RO2PR 15  (72)
                              97.13, true,  0.00, // PJ    16  (76)
                                7.4, true,  0.00, // RPH   17  (33)
                              47.35, true,  0.00, // EC2CT 18 (101)
                               0.72, true,  0.00, // EN2CT 19 (106)
                              19.54, true,  0.00, // EO2CT 20  (94)
                                0.0, true,  0.00, // BAGC  21  (38)
                                0.0, true,  0.00, // BAGO  22  (37)
                              52.89, true,  0.00, // CBF   23  (68)
                              677.4, true,  0.00, // BC2MT 24  (67)
                              56.53, true,  0.00, // BC2CT 25  (58)
                               52.8, true,  0.00, // BC2PR 26  (46)
                              18.51, true,  0.00, // BO2MT 27  (66)
                              10.21, true,  0.00, // BO2CT 28  (57)
                              29.87, true,  0.00, // BO2PR 29  (45)
                               22.7, true,  0.00, // BC3CT 30  (92)
                               7.33, true,  0.00, // BPH   31  (36)
                               4.95, true,  0.00, // COADJ 32  (93)
                              130.7, true,  0.00, // DSPAC 33  (70)
                                0.0, true,  0.00, // UN2MT 34 (107)
                               63.0, false, 0.00, // HRATE 35 (109)
                              100.0, false, 0.00, // PD    36  (81)
                              47.25, true,  0.00, // PC2CT 37  (53)
                              19.65, true,  0.00, // PO2CT 38  (54)
                               0.80, false, 0.00, // RER   39  (69)
                              12.82, false, 0.00, // RRATE 40  (48)
                              461.9, false, 0.00, // TIDVL 41  (47)
                              25.52, true,  0.00, // TC3CT 42  (87)
                              51.51, true,  0.00, // TC2CT 43  (56)
                              34.80, true,  0.00, // TLAMT 44  (89)
                              76.07, true,  0.00, // TN2MT 45 (102)
                              967.0, true,  0.00, // SN2MT 46 (112)
                              570.0, true,  0.00, // TN2PR 47 (103)
                              565.0, true,  0.00, // SN2PR 48 (105)
                              177.6, true,  0.00, // TO2MT 49  (95)
                              14.39, true,  0.00, // TO2CT 50  (55)
                               7.37, true,  0.00, // TPH   51  (59)
                               6.06, false, 0.00, // DVENT 52  (51)
                               2.36, true,  0.00, // PW    53  (80)
                              71.41, true,  0.00, // VC3MT 54  (86)
                              25.52, true,  0.00, // VC3CT 55  (88)
                             1540.0, true,  0.00, // VC2MT 56  (50)
                              51.33, true,  0.00, // VC2CT 57  (61)
                              45.43, true,  0.00, // TC2PR 58  (97)
                              434.8, true,  0.00, // V02MT 59  (98)
                               14.5, true,  0.00, // VO2CT 60  (31)
                              40.00, true,  0.00, // TO2PR 61  (96)
                               7.37, true,  0.00  // VPH   62  (34)
                            };

// --- other subject parameters -----------------------------------------------------------
trade float s_other[] =    {
                      71.08, // AVENT  0  (99) lower than MacPuf - shorter iteration period
                        1.0, // BO2AD  1  (92)
                        4.6, // CONOM  2  (82)
                      240.0, // CONSO  3  (73)
                       7.40, // DPH    4  (43)
                        4.0, // FEV    5 (104)
                        0.0, // PG     6  (75)
                       33.6, // QA     7 (113)
                      33.29, // QB     8  (79)
                       3000, // REFLV  9  (71)
                        0.0, // RVADM 10 (114)
                       6.06, // SVENT 11  (52)
                      45.72, // TC2RF 12  (84)
                       0.10, // TC3AJ 13 (111)
                      317.4, // TC3MT 14  (85)
                        0.0, // XDSPA 15  (44)
                        0.0, // XLACT 16 (115)
                       8.88, // XRESP 17  (64)
		     0.080,  // STRVL 18 (110)
                      100.0  // RCOAJ 19  (32)
                     };
#define NUM_OTH sizeof(s_other)/sizeof(float)                 // number of other parameters
//--- clinical codes ----------------------------------------------------------------------
#define set(F)	crrnt_state |= F                                // set clinical message bit
#define clr(F)	crrnt_state &= ~F                             // clear clinical message bit
#define tst(F)  (crrnt_state & F)                              // test clinical message bit

#define	S00     0X0001
#define	S01     0X0002
#define	S02     0X0004
#define	S03     0X0008
#define	S04     0X0010
#define	S05     0X0020
#define	S06     0X0040
#define	S07     0X0080
#define	S08     0X0100
#define	S09     0X0200
#define S10     0X0400
#define S11     0X0800
#define S12     0X1000
#define S13     0X2000

#define	ALL     -1                             // all clinical message bits, usage clr(ALL)

