// --- ms_variable.h ----------------------------------------------------------------------
// This file is used in the build of the two modules that form the application, Ms Resi.
// The expectation is that a developer would not alter this file.
// The core code of Ms Resi was developed from MacPuf. MacPuf is detailed in in the text,
// "A Computer Model of Human Respiration", C. J.Dickinson, MTP Press, 1977.
// Further text on authorship is available at run time.
// Mal Haysom, Civil Engineering and Physical Sciences, La Trobe University, December 2009

// --- basic defines ----------------------------------------------------------------------
#define HST_LNG	1800					       // number of history records
#define FT      (1.0/60.0)                                    // interation period, minutes
#ifdef __DLL__
	#define trade extern "C" __declspec(dllexport)         		  // for DLL module
#else
	#define trade extern "C" __declspec(dllimport)            // for application module
#endif

// --- bag states -------------------------------------------------------------------------
#define GTC 	9  							  // glottis closed
#define	STD	10						      // standard situation
#define CXA	11					// collection of expired air in bag
#define RBB	12						  // rebreathing from a bag
#define	CDA	13					// carbon dioxide absorber attached

// --- interface module bager() origins ---------------------------------------------------
#define RUN	1						        // run button click
#define RSP     2						// respiration dialogue box

// --- export/import functions ------------------------------------------------------------
trade int model(void); 					 // Dickinson's physiological model
trade void estab_pnt(void);		       // initializes pointers to model() variables
trade bool load_new(void);                            // loads untainted patient parameters
trade bool constant(int NREPT);            // computes all parameters constant during a run
trade void bager(int N, float *CA, float *CB);		      // deals with bag rebreathing
trade int sympt(void);           // indicates various symptoms under appropriate conditions
trade bool death(void);  	       // checks for errors, death and intolerable acidosis


// --- variable structure -----------------------------------------------------------------
struct variable {                                                       // general variable
                char *dsn;                                                   // description
                float vlu;                                                         // value
                float lwr;                                                   // lower limit
                float upr;                                                   // upper limit
                char *unt;                                                          // unit
                };
// --- display structure ------------------------------------------------------------------
struct s_dsply {
	       float fresh; 					     // fresh subject value
               bool hold;                // at death hold existing value or load dead value
               float dead;                                            // dead subject value
               };

